/*
 * Decompiled with CFR 0.152.
 */
package net.deweger.crypto;

import java.math.BigInteger;
import net.deweger.crypto.Util;

public class AES {
    private int mode_min = 0;
    public static int MODE_ECB = 0;
    public static int MODE_CBC = 1;
    public static int MODE_CFB = 2;
    public static int MODE_OFB = 3;
    public static int MODE_CTR = 4;
    private int mode_max = 4;
    private int pad_min = 10;
    public static int PAD_NONE = 10;
    public static int PAD_PKCS7 = 11;
    public static int PAD_BIT = 12;
    private int pad_max = 12;
    private byte[] key = new byte[0];
    private byte[] iv = new byte[0];
    private byte[][] roundKeys;
    private byte[][] state;
    private int mode = this.mode_min;
    private int padding = this.pad_min;
    private byte[] sBox;
    private byte[] invsBox;
    private byte[] rcon;
    Util util = new Util();

    public AES() throws Exception {
        this.sBox = Util.hexToBytes("637c777bf26b6fc53001672bfed7ab76ca82c97dfa5947f0add4a2af9ca472c0b7fd9326363ff7cc34a5e5f171d8311504c723c31896059a071280e2eb27b27509832c1a1b6e5aa0523bd6b329e32f8453d100ed20fcb15b6acbbe394a4c58cfd0efaafb434d338545f9027f503c9fa851a3408f929d38f5bcb6da2110fff3d2cd0c13ec5f974417c4a77e3d645d197360814fdc222a908846eeb814de5e0bdbe0323a0a4906245cc2d3ac629195e479e7c8376d8dd54ea96c56f4ea657aae08ba78252e1ca6b4c6e8dd741f4bbd8b8a703eb5664803f60e613557b986c11d9ee1f8981169d98e949b1e87e9ce5528df8ca1890dbfe6426841992d0fb054bb16");
        this.invsBox = Util.hexToBytes("52096ad53036a538bf40a39e81f3d7fb7ce339829b2fff87348e4344c4dee9cb547b9432a6c2233dee4c950b42fac34e082ea16628d924b2765ba2496d8bd12572f8f66486689816d4a45ccc5d65b6926c704850fdedb9da5e154657a78d9d8490d8ab008cbcd30af7e45805b8b34506d02c1e8fca3f0f02c1afbd0301138a6b3a9111414f67dcea97f2cfcef0b4e67396ac7422e7ad3585e2f937e81c75df6e47f11a711d29c5896fb7620eaa18be1bfc563e4bc6d279209adbc0fe78cd5af41fdda8338807c731b11210592780ec5f60517fa919b54a0d2de57a9f93c99cefa0e03b4dae2af5b0c8ebbb3c83539961172b047eba77d626e169146355210c7d");
        this.rcon = Util.hexToBytes("01020408102040801b36");
    }

    public void setKey(byte[] byArray) throws Exception {
        if (byArray.length != 16) {
            throw new Exception("net.deweger.crypto.AES.setKey: illegal key length: " + byArray.length);
        }
        this.key = byArray;
        this.keyExpansion();
    }

    public void setIv(byte[] byArray) throws Exception {
        if (byArray.length != 16) {
            throw new Exception("net.deweger.crypto.AES.setIv: illegal iv length: " + byArray.length);
        }
        this.iv = byArray;
    }

    public void setMode(int n) throws Exception {
        if (n < this.mode_min || this.mode > this.mode_max) {
            throw new Exception("net.deweger.crypto.AES.setMode: illegal mode: " + n);
        }
        this.mode = n;
    }

    public void setPadding(int n) throws Exception {
        if (n < this.pad_min || n > this.pad_max) {
            throw new Exception("net.deweger.crypto.AES.setMode: illegal padding: " + n);
        }
        this.padding = n;
    }

    public byte[] generateKey() throws Exception {
        this.key = this.util.randomBytes(16);
        this.setKey(this.key);
        return this.key;
    }

    public byte[] generateIv() throws Exception {
        this.iv = this.util.randomBytes(16);
        this.setIv(this.iv);
        return this.iv;
    }

    public byte[] getKey() throws Exception {
        if (this.key.length != 16) {
            throw new Exception("net.deweger.crypto.AES.getKey: illegal key length: " + this.key.length);
        }
        return this.key;
    }

    public byte[] getIv() throws Exception {
        if (this.iv.length != 16) {
            throw new Exception("net.deweger.crypto.AES.getIv: illegal iv length: " + this.iv.length);
        }
        return this.iv;
    }

    public int getMode() throws Exception {
        if (this.mode < this.mode_min || this.mode > this.mode_max) {
            throw new Exception("net.deweger.crypto.AES.getMode: illegal mode: " + this.mode);
        }
        return this.mode;
    }

    public int getPadding() throws Exception {
        if (this.padding < this.pad_min || this.padding > this.pad_max) {
            throw new Exception("net.deweger.crypto.AES.getMode: illegal padding: " + this.padding);
        }
        return this.padding;
    }

    private void keyExpansion() {
        int n;
        int n2;
        this.roundKeys = new byte[44][4];
        for (n2 = 0; n2 <= 3; ++n2) {
            for (n = 0; n <= 3; ++n) {
                this.roundKeys[n2][n] = this.key[4 * n2 + n];
            }
        }
        for (n2 = 4; n2 <= 43; ++n2) {
            if (n2 % 4 == 0) {
                this.roundKeys[n2][0] = (byte)(this.sBox[Byte.toUnsignedInt(this.roundKeys[n2 - 1][1])] ^ this.roundKeys[n2 - 4][0] ^ this.rcon[n2 / 4 - 1]);
                this.roundKeys[n2][1] = (byte)(this.sBox[Byte.toUnsignedInt(this.roundKeys[n2 - 1][2])] ^ this.roundKeys[n2 - 4][1]);
                this.roundKeys[n2][2] = (byte)(this.sBox[Byte.toUnsignedInt(this.roundKeys[n2 - 1][3])] ^ this.roundKeys[n2 - 4][2]);
                this.roundKeys[n2][3] = (byte)(this.sBox[Byte.toUnsignedInt(this.roundKeys[n2 - 1][0])] ^ this.roundKeys[n2 - 4][3]);
                continue;
            }
            for (n = 0; n <= 3; ++n) {
                this.roundKeys[n2][n] = (byte)(this.roundKeys[n2 - 1][n] ^ this.roundKeys[n2 - 4][n]);
            }
        }
    }

    private void subBytes() {
        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                this.state[i][j] = this.sBox[Byte.toUnsignedInt(this.state[i][j])];
            }
        }
    }

    private void subBytesInverse() {
        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                this.state[i][j] = this.invsBox[Byte.toUnsignedInt(this.state[i][j])];
            }
        }
    }

    private void shiftRows() {
        byte by = this.state[1][0];
        this.state[1][0] = this.state[1][1];
        this.state[1][1] = this.state[1][2];
        this.state[1][2] = this.state[1][3];
        this.state[1][3] = by;
        by = this.state[2][0];
        this.state[2][0] = this.state[2][2];
        this.state[2][2] = by;
        by = this.state[2][1];
        this.state[2][1] = this.state[2][3];
        this.state[2][3] = by;
        by = this.state[3][0];
        this.state[3][0] = this.state[3][3];
        this.state[3][3] = this.state[3][2];
        this.state[3][2] = this.state[3][1];
        this.state[3][1] = by;
    }

    private void shiftRowsInverse() {
        byte by = this.state[1][0];
        this.state[1][0] = this.state[1][3];
        this.state[1][3] = this.state[1][2];
        this.state[1][2] = this.state[1][1];
        this.state[1][1] = by;
        by = this.state[2][0];
        this.state[2][0] = this.state[2][2];
        this.state[2][2] = by;
        by = this.state[2][1];
        this.state[2][1] = this.state[2][3];
        this.state[2][3] = by;
        by = this.state[3][0];
        this.state[3][0] = this.state[3][1];
        this.state[3][1] = this.state[3][2];
        this.state[3][2] = this.state[3][3];
        this.state[3][3] = by;
    }

    private byte mul(byte by, int n) {
        byte by2 = 0;
        if (n % 2 == 1) {
            by2 = by;
        }
        if (n / 2 % 2 == 1) {
            by2 = (byte)(by2 ^ by << 1);
            if ((by & 0x80) != 0) {
                by2 = (byte)(by2 ^ 0x1B);
            }
        }
        if (n / 4 % 2 == 1) {
            by2 = (byte)(by2 ^ by << 2);
            if ((by & 0x80) != 0) {
                by2 = (byte)(by2 ^ 0x36);
            }
            if ((by & 0x40) != 0) {
                by2 = (byte)(by2 ^ 0x1B);
            }
        }
        if (n / 8 % 2 == 1) {
            by2 = (byte)(by2 ^ by << 3);
            if ((by & 0x80) != 0) {
                by2 = (byte)(by2 ^ 0x6C);
            }
            if ((by & 0x40) != 0) {
                by2 = (byte)(by2 ^ 0x36);
            }
            if ((by & 0x20) != 0) {
                by2 = (byte)(by2 ^ 0x1B);
            }
        }
        return by2;
    }

    private void mixColumns() {
        byte[] byArray = new byte[4];
        for (int i = 0; i <= 3; ++i) {
            byArray[0] = (byte)(this.mul(this.state[0][i], 2) ^ this.mul(this.state[1][i], 3) ^ this.state[2][i] ^ this.state[3][i]);
            byArray[1] = (byte)(this.state[0][i] ^ this.mul(this.state[1][i], 2) ^ this.mul(this.state[2][i], 3) ^ this.state[3][i]);
            byArray[2] = (byte)(this.state[0][i] ^ this.state[1][i] ^ this.mul(this.state[2][i], 2) ^ this.mul(this.state[3][i], 3));
            byArray[3] = (byte)(this.mul(this.state[0][i], 3) ^ this.state[1][i] ^ this.state[2][i] ^ this.mul(this.state[3][i], 2));
            this.state[0][i] = byArray[0];
            this.state[1][i] = byArray[1];
            this.state[2][i] = byArray[2];
            this.state[3][i] = byArray[3];
        }
    }

    private void mixColumnsInverse() {
        byte[] byArray = new byte[4];
        for (int i = 0; i <= 3; ++i) {
            byArray[0] = (byte)(this.mul(this.state[0][i], 14) ^ this.mul(this.state[1][i], 11) ^ this.mul(this.state[2][i], 13) ^ this.mul(this.state[3][i], 9));
            byArray[1] = (byte)(this.mul(this.state[0][i], 9) ^ this.mul(this.state[1][i], 14) ^ this.mul(this.state[2][i], 11) ^ this.mul(this.state[3][i], 13));
            byArray[2] = (byte)(this.mul(this.state[0][i], 13) ^ this.mul(this.state[1][i], 9) ^ this.mul(this.state[2][i], 14) ^ this.mul(this.state[3][i], 11));
            byArray[3] = (byte)(this.mul(this.state[0][i], 11) ^ this.mul(this.state[1][i], 13) ^ this.mul(this.state[2][i], 9) ^ this.mul(this.state[3][i], 14));
            this.state[0][i] = byArray[0];
            this.state[1][i] = byArray[1];
            this.state[2][i] = byArray[2];
            this.state[3][i] = byArray[3];
        }
    }

    private void addRoundKey(int n) {
        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                this.state[i][j] = (byte)(this.state[i][j] ^ this.roundKeys[4 * n + j][i]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] encryptBlock(byte[] byArray) throws Exception {
        int n;
        int n2;
        byte[] byArray2 = null;
        if (byArray.length != 16) throw new Exception("net.deweger.crypto.AES.encryptBlock: illegal block size: " + byArray.length);
        if (this.key.length != 16) throw new Exception("net.deweger.crypto.AES.encryptBlock: illegal key size: " + this.key.length);
        this.state = new byte[4][4];
        for (n2 = 0; n2 <= 3; ++n2) {
            for (n = 0; n <= 3; ++n) {
                this.state[n2][n] = byArray[n2 + 4 * n];
            }
        }
        this.addRoundKey(0);
        for (n2 = 1; n2 <= 10; ++n2) {
            this.subBytes();
            this.shiftRows();
            if (n2 < 10) {
                this.mixColumns();
            }
            this.addRoundKey(n2);
        }
        byArray2 = new byte[16];
        for (n2 = 0; n2 <= 3; ++n2) {
            for (n = 0; n <= 3; ++n) {
                byArray2[n2 + 4 * n] = this.state[n2][n];
            }
        }
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] decryptBlock(byte[] byArray) throws Exception {
        int n;
        int n2;
        byte[] byArray2 = null;
        if (byArray.length != 16) throw new Exception("net.deweger.crypto.AES.decryptBlock: illegal block size: " + byArray.length);
        if (this.key.length != 16) throw new Exception("net.deweger.crypto.AES.decryptBlock: illegal key size: " + this.key.length);
        this.state = new byte[4][4];
        for (n2 = 0; n2 <= 3; ++n2) {
            for (n = 0; n <= 3; ++n) {
                this.state[n2][n] = byArray[n2 + 4 * n];
            }
        }
        this.addRoundKey(10);
        for (n2 = 10; n2 >= 1; --n2) {
            this.shiftRowsInverse();
            this.subBytesInverse();
            this.addRoundKey(n2 - 1);
            if (n2 <= 1) continue;
            this.mixColumnsInverse();
        }
        byArray2 = new byte[16];
        for (n2 = 0; n2 <= 3; ++n2) {
            for (n = 0; n <= 3; ++n) {
                byArray2[n2 + 4 * n] = this.state[n2][n];
            }
        }
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray) throws Exception {
        int n;
        int n2;
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        int n3 = byArray.length;
        int n4 = 16 - n3 % 16;
        if (n4 == 0) {
            n4 = 16;
        }
        if (this.padding == PAD_NONE) {
            n4 = 0;
        }
        int n5 = n3 + n4;
        byte[] byArray4 = new byte[n5];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        if (this.padding == PAD_PKCS7) {
            for (n2 = 1; n2 <= n4; ++n2) {
                byArray4[n5 - n2] = (byte)n4;
            }
        }
        if (this.padding == PAD_BIT) {
            for (n2 = 1; n2 < n4; ++n2) {
                byArray4[n5 - n2] = 0;
            }
            byArray4[n5 - n4] = -128;
        }
        byte[] byArray5 = new byte[n5];
        if (n5 % 16 != 0) {
            throw new Exception("net.deweger.crypto.AES.encrypt: illegal padded plaintext length: " + n5);
        }
        if (this.mode == MODE_ECB) {
            for (n2 = 0; n2 < n5; n2 += 16) {
                System.arraycopy(byArray4, n2, byArray2, 0, 16);
                byArray3 = this.encryptBlock(byArray2);
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
            }
        }
        if (this.mode == MODE_CBC) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.encrypt: illegal iv length: " + this.iv.length);
            }
            System.arraycopy(this.iv, 0, byArray3, 0, 16);
            for (n2 = 0; n2 < n5; n2 += 16) {
                System.arraycopy(byArray4, n2, byArray2, 0, 16);
                for (n = 0; n <= 15; ++n) {
                    byArray2[n] = (byte)(byArray2[n] ^ byArray3[n]);
                }
                byArray3 = this.encryptBlock(byArray2);
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
            }
        }
        if (this.mode == MODE_CFB) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.encrypt: illegal iv length: " + this.iv.length);
            }
            System.arraycopy(this.iv, 0, byArray3, 0, 16);
            for (n2 = 0; n2 < n5; n2 += 16) {
                byArray3 = this.encryptBlock(byArray3);
                System.arraycopy(byArray4, n2, byArray2, 0, 16);
                for (n = 0; n <= 15; ++n) {
                    byArray3[n] = (byte)(byArray2[n] ^ byArray3[n]);
                }
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
            }
        }
        if (this.mode == MODE_OFB) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.encrypt: illegal iv length: " + this.iv.length);
            }
            byte[] byArray6 = new byte[16];
            System.arraycopy(this.iv, 0, byArray6, 0, 16);
            for (n2 = 0; n2 < n5; n2 += 16) {
                byArray6 = this.encryptBlock(byArray6);
                System.arraycopy(byArray4, n2, byArray2, 0, 16);
                for (int i = 0; i <= 15; ++i) {
                    byArray3[i] = (byte)(byArray2[i] ^ byArray6[i]);
                }
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
            }
        }
        if (this.mode == MODE_CTR) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.encrypt: illegal iv length: " + this.iv.length);
            }
            n2 = 0;
            byte[] byArray7 = new byte[16];
            System.arraycopy(this.iv, 0, byArray7, 0, 8);
            BigInteger bigInteger = BigInteger.ZERO;
            while (n2 < n5) {
                byte[] byArray8 = bigInteger.toByteArray();
                System.arraycopy(byArray8, 0, byArray7, 16 - byArray8.length, byArray8.length);
                byArray3 = this.encryptBlock(byArray7);
                System.arraycopy(byArray4, n2, byArray2, 0, 16);
                for (int i = 0; i <= 15; ++i) {
                    byArray3[i] = (byte)(byArray2[i] ^ byArray3[i]);
                }
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
                n2 += 16;
                bigInteger = bigInteger.add(BigInteger.ONE);
            }
        }
        return byArray5;
    }

    public byte[] decrypt(byte[] byArray) throws Exception {
        int n;
        byte[] byArray2;
        int n2;
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        int n3 = byArray.length;
        byte[] byArray5 = new byte[n3];
        if (n3 % 16 != 0) {
            throw new Exception("net.deweger.crypto.AES.decrypt: illegal ciphertext length: " + n3);
        }
        if (this.mode == MODE_ECB) {
            for (n2 = 0; n2 < n3; n2 += 16) {
                System.arraycopy(byArray, n2, byArray4, 0, 16);
                byArray3 = this.decryptBlock(byArray4);
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
            }
        }
        if (this.mode == MODE_CBC) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal iv length: " + this.iv.length);
            }
            byArray2 = new byte[16];
            System.arraycopy(this.iv, 0, byArray2, 0, 16);
            for (n2 = 0; n2 < n3; n2 += 16) {
                System.arraycopy(byArray, n2, byArray4, 0, 16);
                byArray3 = this.decryptBlock(byArray4);
                for (n = 0; n <= 15; ++n) {
                    byArray3[n] = (byte)(byArray3[n] ^ byArray2[n]);
                }
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
                System.arraycopy(byArray4, 0, byArray2, 0, 16);
            }
        }
        if (this.mode == MODE_CFB) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal iv length: " + this.iv.length);
            }
            byArray2 = new byte[16];
            System.arraycopy(this.iv, 0, byArray2, 0, 16);
            for (n2 = 0; n2 < n3; n2 += 16) {
                System.arraycopy(byArray, n2, byArray4, 0, 16);
                byArray3 = this.encryptBlock(byArray2);
                for (n = 0; n <= 15; ++n) {
                    byArray3[n] = (byte)(byArray3[n] ^ byArray4[n]);
                }
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
                System.arraycopy(byArray4, 0, byArray2, 0, 16);
            }
        }
        if (this.mode == MODE_OFB) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal iv length: " + this.iv.length);
            }
            byArray2 = new byte[16];
            System.arraycopy(this.iv, 0, byArray2, 0, 16);
            for (n2 = 0; n2 < n3; n2 += 16) {
                byArray2 = this.encryptBlock(byArray2);
                System.arraycopy(byArray, n2, byArray4, 0, 16);
                for (n = 0; n <= 15; ++n) {
                    byArray3[n] = (byte)(byArray2[n] ^ byArray4[n]);
                }
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
            }
        }
        if (this.mode == MODE_CTR) {
            if (this.iv.length != 16) {
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal iv length: " + this.iv.length);
            }
            n2 = 0;
            byArray2 = new byte[16];
            System.arraycopy(this.iv, 0, byArray2, 0, 8);
            BigInteger bigInteger = BigInteger.ZERO;
            while (n2 < n3) {
                byte[] byArray6 = bigInteger.toByteArray();
                System.arraycopy(byArray6, 0, byArray2, 16 - byArray6.length, byArray6.length);
                byArray3 = this.encryptBlock(byArray2);
                System.arraycopy(byArray, n2, byArray4, 0, 16);
                for (int i = 0; i <= 15; ++i) {
                    byArray3[i] = (byte)(byArray3[i] ^ byArray4[i]);
                }
                System.arraycopy(byArray3, 0, byArray5, n2, 16);
                n2 += 16;
                bigInteger = bigInteger.add(BigInteger.ONE);
            }
        }
        n2 = 0;
        if (this.padding == PAD_PKCS7) {
            n2 = byArray5[n3 - 1];
            if (n2 <= 0 || n2 > n3) {
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal padding (PKCS7)");
            }
            for (int i = 1; i <= n2; ++i) {
                if (byArray5[n3 - i] == n2) continue;
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal padding (PKCS7)");
            }
        }
        if (this.padding == PAD_BIT) {
            for (n2 = 1; byArray5[n3 - n2] == 0 && n2 < 16; ++n2) {
            }
            if (n2 <= 0 || n2 > n3) {
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal padding (BIT)");
            }
            if (byArray5[n3 - n2] != -128) {
                throw new Exception("net.deweger.crypto.AES.decrypt: illegal padding (BIT)");
            }
        }
        int n4 = n3 - n2;
        byte[] byArray7 = new byte[n4];
        System.arraycopy(byArray5, 0, byArray7, 0, n4);
        return byArray7;
    }
}

