/*
 * Decompiled with CFR 0.152.
 */
package net.deweger.crypto;

public class SHA256 {
    private static long[] y = new long[]{1116352408L, 1899447441L, 3049323471L, 3921009573L, 961987163L, 1508970993L, 2453635748L, 2870763221L, 3624381080L, 310598401L, 607225278L, 1426881987L, 1925078388L, 2162078206L, 2614888103L, 3248222580L, 3835390401L, 4022224774L, 264347078L, 604807628L, 770255983L, 1249150122L, 1555081692L, 1996064986L, 2554220882L, 2821834349L, 2952996808L, 3210313671L, 3336571891L, 3584528711L, 113926993L, 338241895L, 666307205L, 773529912L, 1294757372L, 1396182291L, 1695183700L, 1986661051L, 2177026350L, 2456956037L, 2730485921L, 2820302411L, 3259730800L, 3345764771L, 3516065817L, 3600352804L, 4094571909L, 275423344L, 430227734L, 506948616L, 659060556L, 883997877L, 958139571L, 1322822218L, 1537002063L, 1747873779L, 1955562222L, 2024104815L, 2227730452L, 2361852424L, 2428436474L, 2756734187L, 3204031479L, 3329325298L};
    private static long[] iv = new long[]{1779033703L, 3144134277L, 1013904242L, 2773480762L, 1359893119L, 2600822924L, 528734635L, 1541459225L};
    private long[] state;
    private long[] intState;
    private long count;
    private byte[] buffer;
    private int bufferFilled;
    private byte[] padding;
    private byte[] hashValue;

    private byte[] stateToBytes(long[] lArray) {
        byte[] byArray = new byte[lArray.length * 4];
        for (int i = 0; i < lArray.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                byArray[4 * (i + 1) - j - 1] = (byte)(lArray[i] >>> 8 * j & 0xFFL);
            }
        }
        return byArray;
    }

    private static long f(long l, long l2, long l3) {
        return l & l2 | (l ^ 0xFFFFFFFFFFFFFFFFL) & l3;
    }

    private static long g(long l, long l2, long l3) {
        return l & l2 | l & l3 | l2 & l3;
    }

    private static long shift32(long l, int n) {
        return (l << n | l >>> (int)(32L - (long)n)) & 0xFFFFFFFFL;
    }

    private static long shift(long l, int n) {
        return SHA256.shift32(l, n);
    }

    private long Sigma(int n, int n2, int n3, long l) {
        return SHA256.shift(l, 32 - n) ^ SHA256.shift(l, 32 - n2) ^ SHA256.shift(l, 32 - n3);
    }

    private long sigma(int n, int n2, int n3, long l) {
        return SHA256.shift(l, 32 - n) ^ SHA256.shift(l, 32 - n2) ^ l >>> n3;
    }

    private void compress() {
        int n;
        long[] lArray = new long[64];
        for (n = 0; n < 16; ++n) {
            long[] lArray2 = new long[4];
            for (int i = 0; i < 4; ++i) {
                lArray2[i] = this.buffer[n * 4 + i];
                if (lArray2[i] >= 0L) continue;
                int n2 = i;
                lArray2[n2] = lArray2[n2] + 256L;
            }
            lArray[n] = lArray2[3] + (lArray2[2] << 8) + (lArray2[1] << 16) + (lArray2[0] << 24);
        }
        for (n = 16; n < 64; ++n) {
            lArray[n] = this.sigma(17, 19, 10, lArray[n - 2]) + lArray[n - 7] + this.sigma(7, 18, 3, lArray[n - 15]) + lArray[n - 16] & 0xFFFFFFFFL;
        }
        for (n = 0; n < 8; ++n) {
            this.intState[n] = this.state[n];
        }
        for (n = 0; n < 64; ++n) {
            long l = this.intState[7] + this.Sigma(6, 11, 25, this.intState[4]) + SHA256.f(this.intState[4], this.intState[5], this.intState[6]) + lArray[n] + y[n] & 0xFFFFFFFFL;
            long l2 = this.Sigma(2, 13, 22, this.intState[0]) + SHA256.g(this.intState[0], this.intState[1], this.intState[2]) & 0xFFFFFFFFL;
            this.intState[7] = this.intState[6];
            this.intState[6] = this.intState[5];
            this.intState[5] = this.intState[4];
            this.intState[4] = this.intState[3] + l & 0xFFFFFFFFL;
            this.intState[3] = this.intState[2];
            this.intState[2] = this.intState[1];
            this.intState[1] = this.intState[0];
            this.intState[0] = l + l2 & 0xFFFFFFFFL;
        }
        for (n = 0; n < 8; ++n) {
            this.state[n] = this.state[n] + this.intState[n] & 0xFFFFFFFFL;
        }
    }

    private void pad() {
        int n;
        int n2 = 56 - this.bufferFilled;
        if (n2 <= 0) {
            n2 += 64;
        }
        this.padding = new byte[n2 + 8];
        this.padding[0] = -128;
        for (n = 1; n <= n2 - 1; ++n) {
            this.padding[n] = 0;
        }
        for (n = 0; n < 8; ++n) {
            this.padding[n2 + 7 - n] = (byte)(this.count >>> 8 * n & 0xFFL);
        }
    }

    public void hashInit() throws Exception {
        this.state = new long[8];
        this.intState = new long[8];
        this.buffer = new byte[64];
        this.count = 0L;
        this.bufferFilled = 0;
        for (int i = 0; i < 8; ++i) {
            this.state[i] = iv[i];
        }
    }

    public void hashUpdate(byte[] byArray) throws Exception {
        int n = this.bufferFilled;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 64 - n;
        while (n2 >= n4) {
            System.arraycopy(byArray, n3, this.buffer, n, n4);
            this.compress();
            this.count += (long)(n4 << 3);
            n = 0;
            n2 -= n4;
            n3 += n4;
            n4 = 64;
        }
        this.bufferFilled = n + n2;
        if (n2 > 0) {
            System.arraycopy(byArray, n3, this.buffer, n, n2);
            this.count += (long)(n2 << 3);
        }
    }

    public byte[] hashFinal() throws Exception {
        this.pad();
        this.hashUpdate(this.padding);
        this.hashValue = new byte[32];
        byte[] byArray = this.stateToBytes(this.state);
        System.arraycopy(byArray, 0, this.hashValue, 0, 32);
        return this.hashValue;
    }

    public byte[] hashFinal(byte[] byArray) throws Exception {
        this.hashUpdate(byArray);
        return this.hashFinal();
    }

    public byte[] hash(byte[] byArray) throws Exception {
        this.hashInit();
        return this.hashFinal(byArray);
    }

    public byte[] hMac(byte[] byArray, byte[] byArray2) throws Exception {
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[64];
        byte[] byArray5 = new byte[64];
        byte[] byArray6 = new byte[32];
        if (byArray.length > 64) {
            System.arraycopy(this.hash(byArray), 0, byArray3, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        }
        for (int i = 0; i <= 63; ++i) {
            byArray4[i] = (byte)(byArray3[i] ^ 0x5C);
            byArray5[i] = (byte)(byArray3[i] ^ 0x36);
        }
        this.hashInit();
        this.hashUpdate(byArray5);
        byArray6 = this.hashFinal(byArray2);
        this.hashInit();
        this.hashUpdate(byArray4);
        return this.hashFinal(byArray6);
    }
}

