/*
 * Decompiled with CFR 0.152.
 */
package net.deweger.crypto;

import java.math.BigInteger;
import java.security.SecureRandom;

public class Util {
    public SecureRandom secureRandom = new SecureRandom();

    public byte[] randomBytes(int n) {
        byte[] byArray = new byte[n];
        this.secureRandom.nextBytes(byArray);
        return byArray;
    }

    public static String byteToHex(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Character.forDigit(by >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(by & 0xF, 16));
        return stringBuffer.toString();
    }

    public static String bytesToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Character.forDigit(byArray[i] >> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[i] & 0xF, 16));
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToBytes(String string) throws Exception {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            int n2 = Character.digit(string.charAt(i), 16);
            int n3 = Character.digit(string.charAt(i + 1), 16);
            if (n2 == -1 || n3 == -1) {
                throw new Exception("net.deweger.crypto.Util.hexToBytes: illegal character");
            }
            byArray[i / 2] = (byte)((n2 << 4) + n3);
        }
        return byArray;
    }

    public static String bytesToHex64(byte[] byArray) throws Exception {
        return Util.bytesToHex(byArray).replaceAll(".{64}", "$0\n");
    }

    public static byte[] hexToBytes64(String string) throws Exception {
        return Util.hexToBytes(string.replaceAll("\n", ""));
    }

    public static byte[] bigIntegerToByteArray(BigInteger bigInteger) throws Exception {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[byArray.length];
        if (byArray[0] == 0) {
            byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static String bigIntegerToHex64(BigInteger bigInteger) throws Exception {
        String string = Util.bytesToHex(Util.bigIntegerToByteArray(bigInteger)).replaceAll(".{64}", "$0\n");
        if (string.length() % 65 == 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static BigInteger squareRoot(BigInteger bigInteger) throws Exception {
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new Exception("net.deweger.crypto.Util.squareRoot: negative input is not allowed");
        }
        if (bigInteger.compareTo(BigInteger.ONE) <= 0) {
            return bigInteger;
        }
        BigInteger bigInteger2 = BigInteger.ONE.shiftLeft((bigInteger.bitLength() + 1) / 2);
        BigInteger bigInteger3 = BigInteger.ZERO;
        while (!bigInteger2.equals(bigInteger3)) {
            bigInteger3 = bigInteger2;
            if (!(bigInteger2 = bigInteger2.multiply(bigInteger2).add(bigInteger).divide(bigInteger2.shiftLeft(1))).equals(bigInteger3.add(BigInteger.ONE))) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    public static BigInteger thirdRoot(BigInteger bigInteger) throws Exception {
        if (bigInteger.compareTo(BigInteger.ONE.negate()) < 0) {
            return Util.thirdRoot(bigInteger.negate()).negate();
        }
        if (bigInteger.compareTo(BigInteger.ONE) <= 0) {
            return bigInteger;
        }
        BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(bigInteger.bitLength() / 3);
        BigInteger bigInteger3 = BigInteger.ZERO;
        while (!bigInteger2.equals(bigInteger3)) {
            bigInteger3 = bigInteger2;
            BigInteger bigInteger4 = bigInteger2.multiply(bigInteger2);
            if ((bigInteger2 = bigInteger2.multiply(bigInteger4).shiftLeft(1).add(bigInteger).divide(bigInteger4.multiply(new BigInteger("3")))).multiply(bigInteger2).multiply(bigInteger2).compareTo(bigInteger) >= 0) continue;
            throw new Exception("net.deweger.crypto.Util.thirdRoot: input is not an exact third power");
        }
        return bigInteger2;
    }
}

