// DHapp
// Benne de Weger - TU/e - February 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 14 - application

import net.deweger.crypto.*;

public class DHapp
{
    // main
    public static void main(String[] args)
    {
        try
        {
            DH alice = new DH("Alice");
            DH bob   = new DH("Bob");
            alice.generateDHSystemParameters(1024);
            alice.writeDHSystemParameters("DHSysPar.txt");
            bob.readDHSystemParameters("DHSysPar.txt");
            alice.generateDHKeyPair();
            alice.writeDHPublicKey("DHalicePub.txt");
            alice.secureWriteDHPrivateKey("alice_secret", "DHalicePri.txt");
            bob.generateDHKeyPair();
            bob.writeDHPublicKey("DHbobPub.txt");
            bob.secureWriteDHPrivateKey("bob_secret", "DHbobPri.txt");
            alice.readPartnerDHPublicKey("DHbobPub.txt", "Bob");
            alice.deriveSharedSecret();
            bob.readPartnerDHPublicKey("DHalicePub.txt", "Alice");
            bob.deriveSharedSecret();
            System.out.println("alice's shared secret: " + Util.bytesToHex(alice.s));
            System.out.println("  bob's shared secret: " + Util.bytesToHex(bob.s));
        }
        catch (Exception e)
        {
            System.out.println("Error: "+ e.getMessage());
            e.printStackTrace();
        }
    }
}
