// Brute Forcing PBE
// Benne de Weger - TU/e - February 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 3 - application

// assumptions:
// plaintext has only readable characters (0x0a, 0x0d, 0x20 - 0x7e)
// password has only uppercase and lowercase letters and digits (0x30 - 0x39, 0x40 - 0x59, 0x60 - 0x79)

import net.deweger.crypto.*;

import java.io.*;
import java.nio.file.*;
import java.nio.charset.StandardCharsets;

public class PBEBruteForce
{
    static int NONE = 0;
    static int BIN = 3;
    static int HEX = 4;

    // check fopr readable character
    private static boolean readableCharacter(byte b)
    {
        return (b == (byte)0x0a) || (b == (byte)0x0d) || ((b >= (byte)0x20) && (b <= (byte)0x7e));
    }

    // 5 arguments expected: -b|-h -f fileName -l maximum_password_length
    // -b: binary decrypted file
    // -h: hexstring decrypted file
    public static void main(String[] args)
    {
        try
        {
            int pretty = NONE;
            String fileIn = "";
            String fileOut = "";
            String username = "FAECTOR";
            String password = "";
            int pwLen = 0;

            // parse arguments
            if (args.length != 5)
            {
                System.out.println("usage: java -cp .;crypto.jar PBEBruteForce -b|-h -f filename -l maximum_password_length");
                throw new Exception("wrong number of arguments");
            }
            for (int i = 0; i < 5; i++)
            {
                if (pretty == NONE && args[i].equals("-b"))
                    pretty = BIN;
                if (pretty == NONE && args[i].equals("-h"))
                    pretty = HEX;
                if (fileIn.equals("") && args[i].equals("-f"))
                {
                    i++;
                    fileIn = args[i];
                    fileOut = fileIn + ".dec";
                }
                if (pwLen == 0 && args[i].equals("-l"))
                {
                    i++;
                    pwLen = Integer.parseInt(args[i]);
                }
            }
            if (pretty == NONE)
                throw new Exception("illegal argument -b|-h");
            if (fileIn.equals(""))
                throw new Exception("illegal argument -f");

            // initiate pbe
            PBE pbe;
            pbe = new PBE();
            pbe.setSalt(username.getBytes());
            pbe.setIterationCount(1000);

            // read file
            byte[] in = Files.readAllBytes(Paths.get(fileIn));
            System.out.println("read " + in.length + " bytes from file " + fileIn);

            byte[] out = null;
            long t0 = System.currentTimeMillis();
            boolean stop = false;
            boolean ok = false;

            // loop over all possible passwords
            for (int len = 1; len <= pwLen; len++)
            {
                int[] ind = new int[len];
                password = "";
                for (int i = 0; i < len; i++)
                    password += "0";
                stop = false;
                while (!stop)
                {
                    pbe.setPassword(password);
                    ok = true;
                    try
                    {
                        if (pretty == BIN)
                            out = pbe.decrypt(in);
                        if (pretty == HEX)
                            out = pbe.decrypt(Util.hexToBytes64(new String(in, StandardCharsets.UTF_8)));
                    }
                    catch(Exception e)
                    {
                        if (e.getMessage().equals("net.deweger.crypto.AES.decrypt: illegal padding (PKCS7)"))
                            ok = false;
                    }
                    int i = 0;
                    while (ok && i < out.length)
                    {
                        ok = readableCharacter(out[i]);
                        if (ok)
                            i++;
                    }
                    if (ok)
                    {
                        stop = true;
                        len = pwLen + 1;
                    }
                    else
                    {
                        ind[len-1]++;
                        for (i = len-1; i > 0; i--)
                        {
                            if (ind[i] == 62)
                            {
                                ind[i] = 0;
                                ind[i-1]++;
                            }
                        }
                        if (ind[0] == 62)
                            stop = true;
                        else
                        {
                            password = "";
                            for (i = 0; i < len; i++)
                                password += "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt(ind[i]);
                        }
                    }
                }
            }


            t0 = System.currentTimeMillis() - t0;

            if (ok)
            {
                // write password
                System.out.println("password: " + password);

                Files.write(Paths.get(fileOut), out);
                System.out.println("written " + out.length + " bytes to file " + fileOut);
            }
            else
                System.out.println("password not found...");
            System.out.println("time:   " + t0/1000. + " sec.");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: PBE " + e.getMessage());
        }
    }
}
