// Tests for PBE class
// Benne de Weger - TU/e - January 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 2 - application

import net.deweger.crypto.*;

import java.io.*;
import java.nio.file.*;
import java.nio.charset.StandardCharsets;

public class PBEFileCrypt
{
    static int NONE = 0;
    static int ENC = 1;
    static int DEC = 2;
    static int BIN = 3;
    static int HEX = 4;

    // 8 arguments expected: -e|-d -b|-h -f fileName -u username -p password
    // -e: file "fileName" will be encrypted into file "fileName.enc"
    // -d: file "fileName" will be decrypted into file "fileName.dec"
    // -b: binary decrypted file
    // -h: hexstring decrypted file
    public static void main(String[] args)
    {
        try
        {
            int mode = NONE;
            int pretty = NONE;
            String fileIn = "";
            String fileOut = "";
            String username = "";
            String password = "";

            // parse arguments
            if (args.length != 8)
            {
                System.out.println("usage: java -cp .;crypto.jar PBEFileCrypt -e|-d -b|-h -f filename -u username -p password");
                throw new Exception("wrong number of arguments");
            }
            for (int i = 0; i < 8; i++)
            {
                if (mode == NONE && args[i].equals("-e"))
                    mode = ENC;
                if (mode == NONE && args[i].equals("-d"))
                    mode = DEC;
                if (pretty == NONE && args[i].equals("-b"))
                    pretty = BIN;
                if (pretty == NONE && args[i].equals("-h"))
                    pretty = HEX;
                if (fileIn.equals("") && args[i].equals("-f"))
                {
                    i++;
                    fileIn = args[i];
                }
                if (username.equals("") && args[i].equals("-u"))
                {
                    i++;
                    username = args[i];
                }
                if (password.equals("") && args[i].equals("-p"))
                {
                    i++;
                    password = args[i];
                }
            }
            if (mode == NONE)
                throw new Exception("illegal argument -e|-d");
            if (pretty == NONE)
                throw new Exception("illegal argument -b|-h");
            if (fileIn.equals(""))
                throw new Exception("illegal argument -f");
            if (username.equals(""))
                throw new Exception("illegal argument -u");
            if (password.equals(""))
                throw new Exception("illegal argument -p");

            // set output file
            if (mode == ENC)
                fileOut = fileIn + ".enc";
            if (mode == DEC)
                fileOut = fileIn + ".dec";

            // initiate pbe
            PBE pbe;
            pbe = new PBE();
            pbe.setPassword(password);
            pbe.setSalt(username.getBytes());
            pbe.setIterationCount(1000);

            // read file
            byte[] in = Files.readAllBytes(Paths.get(fileIn));
            System.out.println("read " + in.length + " bytes from file " + fileIn);

            // actual encryption / decryption
            byte[] out = null;
            long t0 = System.currentTimeMillis();
            if (mode == ENC && pretty == BIN)
                out = pbe.encrypt(in);
            if (mode == DEC && pretty == BIN)
                out = pbe.decrypt(in);
            if (mode == ENC && pretty == HEX)
                out = Util.bytesToHex64(pbe.encrypt(in)).getBytes();
            if (mode == DEC && pretty == HEX)
                out = pbe.decrypt(Util.hexToBytes64(new String(in, StandardCharsets.UTF_8)));
            t0 = System.currentTimeMillis() - t0;

            // write file
            Files.write(Paths.get(fileOut), out);
            System.out.println("written " + out.length + " bytes to file " + fileOut);
            System.out.println("time:   " + t0/1000. + " sec.\nperformance: "
                               + ((int)((1000000.*in.length) / (1048576.*t0)))/1000. + " MB/sec.");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: PBE " + e.getMessage());
        }
    }
}
