// Pollard Rho
// Benne de Weger - TU/e - March 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 15 - application

import net.deweger.crypto.*;

import java.math.BigInteger;

public class PollardRho
{
    // Assignment 19
    // generate RSA modulus, b = number of bits in the modulus
    private static BigInteger generateRSAModulus(int b)
    {
        Util util = new Util();
        BigInteger p, q;
        BigInteger n = BigInteger.ONE;
        // primes and modulus
        while (n.bitLength() != b)
        {
            p = BigInteger.probablePrime((b+1)/2, util.secureRandom);
            q = BigInteger.probablePrime((b+1)/2, util.secureRandom);
            n = p.multiply(q);
        }
        return n;
    }

    // f(x) = x^2 + 1 mod n
    private static BigInteger f(BigInteger x, BigInteger n)
    {
        return x.multiply(x).add(BigInteger.ONE).mod(n);
    }

    // cycle finder
    private static void pollardRho(BigInteger n, int timeout)
    {
        System.out.println("n = " + n.toString());
        BigInteger tortoise = f(BigInteger.ONE, n);
        BigInteger hare = f(tortoise, n);
        BigInteger gcd = n.gcd(tortoise.subtract(hare));
        int count = 1;
        while (gcd.equals(BigInteger.ONE) && count <= timeout)
        {
            tortoise = f(tortoise, n);
            hare = f(f(hare,n),n);
            gcd = n.gcd(tortoise.subtract(hare));
            count++;
        }
        if (count > timeout)
            System.out.println("timeout...");
        else if (gcd.equals(n))
            System.out.println("gcd found is equal to n, count = " + count);
        else
            System.out.println("factors found: " + gcd.toString() + ", " + n.divide(gcd).toString() + ", count = " + count);
    }

    // main
    public static void main(String[] args)
    {
        BigInteger n = generateRSAModulus(80);
        pollardRho(n, 1000000);
    }
}
