// RSA Fermat
// Benne de Weger - TU/e - February 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 16 - application

import net.deweger.crypto.*;

import java.math.BigInteger;

public class RSAFermat
{
    private BigInteger p = BigInteger.ONE;
    private BigInteger q = BigInteger.ONE;
    private BigInteger n = BigInteger.ONE;
    Util util;

    // constructor
    public RSAFermat()
    {
        util = new Util();
    }

    // Assignment 16
    // generate weak RSA modulus, b = number of bits in the modulus
    // delta = number of bits prime difference
    private void generateWeakRSAModulus(int b, int d)
    {
        // primes and modulus
        while (n.bitLength() != b)
        {
            p = BigInteger.probablePrime((b+1)/2, util.secureRandom);
            q = p.add((new BigInteger(d-1, util.secureRandom)).multiply(BigInteger.TWO));
            while (!q.isProbablePrime(100))
                q = q.subtract(BigInteger.TWO);
            n = p.multiply(q);
        }
    }

    private BigInteger[] fermatFactor(BigInteger n, int timeout)
    {
        BigInteger[] pq = new BigInteger[2];
        pq[0] = BigInteger.ONE;
        pq[1] = n;
        int count = 0;
        long t0, t1;
        boolean stopped = false;

        BigInteger x = n.sqrt();
        if (n.equals(x.multiply(x)))
        {
            pq[0] = x;
            pq[1] = x;
            System.out.println("count = "+ count + "\n");
            return pq;
        }
        else
        {
            x = x.add(BigInteger.ONE);
            BigInteger y2 = x.multiply(x).subtract(n);
            BigInteger y = y2.sqrt();
            count++;
            t0 = System.currentTimeMillis();
            t1 = t0;
            while ((!y2.equals(y.multiply(y))) && !stopped)
            {
                y2 = y2.add(x);
                x = x.add(BigInteger.ONE);
                y2 = y2.add(x);
                y = y2.sqrt();
                count++;
                t1 = System.currentTimeMillis();
                stopped = (t1-t0) >= timeout * 1000;
            }
            if (!stopped)
            {
                pq[0] = x.subtract(y);
                pq[1] = x.add(y);
            }
            else
                System.out.println("timeout...");
            System.out.println("count = "+ count);
            System.out.println("time =  "+ (t1-t0)/1000. + " sec.");
            return pq;
        }
    }

    private static void test(int modulusSize, int privateExponentSize, int timeout)
    {
        RSAFermat rsaFermat = new RSAFermat();
        rsaFermat.generateWeakRSAModulus(modulusSize, privateExponentSize);
        System.out.println("modulus size = " + modulusSize);
        System.out.println("private exponent size = " + privateExponentSize);
        System.out.println("n = " + rsaFermat.n.toString(16));
        BigInteger[] pq = rsaFermat.fermatFactor(rsaFermat.n, timeout);
        System.out.println("p = " + pq[0].toString(16));
        System.out.println("q = " + pq[1].toString(16));
        System.out.println();
    }

    // main, test different bitsizes
    public static void main(String[] args)
    {
        test(512, 138, 60);
        test(512, 139, 60);
        test(512, 140, 60);
        test(512, 141, 60);
        test(512, 142, 60);
    }
}
