// RSA Haastad
// Benne de Weger - TU/e - March 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 19 - application

import net.deweger.crypto.*;

import java.math.BigInteger;

public class RSAHaastad
{
    private BigInteger p = BigInteger.ONE;
    private BigInteger q = BigInteger.ONE;
    private BigInteger n = BigInteger.ONE;
    private BigInteger e = BigInteger.ZERO;
    private BigInteger d = BigInteger.ZERO;
    Util util;

    // constructor
    public RSAHaastad()
    {
        util = new Util();
    }

    // Assignment 19
    // generate RSA public key, with e = 3
    public void generateHaastadRSAPublicKey(int b)
    {
        // public exponent e
        e = new BigInteger("3");

        // primes and modulus
        while (n.bitLength() != b)
        {
            p = BigInteger.ONE;
            q = BigInteger.ONE;
            while (p.mod(e).equals(BigInteger.ONE))
                p = BigInteger.probablePrime((b+1)/2, util.secureRandom);
            while (q.mod(e).equals(BigInteger.ONE))
                q = BigInteger.probablePrime((b+1)/2, util.secureRandom);
            n = p.multiply(q);
        }
    }

    // main
    public static void main(String[] args)
    {
        // three different public key owners
        RSAHaastad user1 = new RSAHaastad();
        RSAHaastad user2 = new RSAHaastad();
        RSAHaastad user3 = new RSAHaastad();

        // three different public keys but all with e = 3
        user1.generateHaastadRSAPublicKey(2048);
        user2.generateHaastadRSAPublicKey(2048);
        user3.generateHaastadRSAPublicKey(2048);
        BigInteger n1 = user1.n;
        BigInteger n2 = user2.n;
        BigInteger n3 = user3.n;

        // random message
        BigInteger message = new BigInteger(2046, user1.util.secureRandom);
        System.out.println("original message: " + message.toString(16));

        // three ciphertexts
        BigInteger c1 = message.modPow(user1.e, n1);
        BigInteger c2 = message.modPow(user2.e, n2);
        BigInteger c3 = message.modPow(user3.e, n3);

        // Chinese Remainder Theorem
        BigInteger c12 = c2.subtract(c1).multiply(n1.modInverse(n2)).mod(n2).multiply(n1).add(c1);
        BigInteger c = c3.subtract(c12).multiply(n1.multiply(n2).modInverse(n3)).mod(n3).multiply(n1).multiply(n2).add(c12);

        // compute third root
        try
        {
            BigInteger m = Util.thirdRoot(c);
            System.out.println("cryptanalyzed message: " + m.toString(16));
        }
        catch(Exception exc)
        {
            System.out.println("ERROR in RSAHaastad: no exact third power");
        }
    }
}
