// RSA MicroWave
// Benne de Weger - TU/e - March 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 20 - application

import net.deweger.crypto.*;

import java.nio.file.*;
import java.nio.charset.StandardCharsets;
import java.math.BigInteger;
import java.util.List;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;

public class RSAMicroWave
{
    // main
    public static void main(String[] args)
    {
        int b = 1024;
        BigInteger p = BigInteger.ONE;
        BigInteger q = BigInteger.ONE;
        BigInteger n = BigInteger.ONE;
        BigInteger e = new BigInteger("65537");
        BigInteger d = BigInteger.ZERO;
        BigInteger dp = BigInteger.ZERO;
        BigInteger dq = BigInteger.ZERO;
        BigInteger u = BigInteger.ZERO;

        Util util = new Util();

        try
        {
            // generate key pair
            while (n.bitLength() != b || n.mod(e).equals(BigInteger.ZERO))
            {
                p = BigInteger.probablePrime((b+1)/2, util.secureRandom);
                q = BigInteger.probablePrime((b+1)/2, util.secureRandom);
                n = p.multiply(q);
            }

            // phi(n)
            BigInteger phi = p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE));

            // private exponent d
            d = e.modInverse(phi);
            dp = d.mod(p.subtract(BigInteger.ONE));
            dq = d.mod(q.subtract(BigInteger.ONE));
            u = q.modInverse(p);

            dq = dq.flipBit(ThreadLocalRandom.current().nextInt(2, dq.bitLength() - 4));

            // generate signature from smartcard
            BigInteger h = new BigInteger(b-1, 100, util.secureRandom);
            BigInteger sp = h.modPow(dp, p);
            BigInteger sq = h.modPow(dq, q);
            BigInteger s = sp.subtract(sq).multiply(u).multiply(q).add(sq).mod(n);

            // verify signature, recover hash
            BigInteger h1 = s.modPow(e, n);

            // recover prime factor
            BigInteger pp = n.gcd(h.subtract(h1));
            BigInteger qq = n.divide(pp);

            System.out.println("generated prime factors:");
            System.out.println("p = " + p.toString());
            System.out.println("q = " + q.toString());
            System.out.println("recovered prime factors:");
            System.out.println("p = " + pp.toString());
            System.out.println("q = " + qq.toString());
        }
        catch (Exception exc)
        {
            System.out.println("ERROR: RSAMicroWave: " + exc.getMessage());
        }
    }
}
