// RSAapp
// Benne de Weger - TU/e - February 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 6, 7, 8, 10, 11, 12 - application

import net.deweger.crypto.*;
//import java.math.BigInteger;
//import java.io.*;
//import java.util.List;
//import java.util.ArrayList;
//import java.nio.file.*;
//import java.nio.charset.StandardCharsets;

public class RSAapp
{
    boolean crt = false;
    int modulusBitSize = 0;

    // test one key pair
    private static void testOne(int b, boolean f4, boolean c)
    {
        System.out.println("========== b = " + b + ", fermat4 = " + f4 + ", CRT = " + c + " ==========");
        RSA rsa1 = null;
        RSA rsa2 = null;
        long t0;
        try
        {
            rsa1 = new RSA("Alice");
            rsa2 = new RSA("Alice");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }

        // generate
        try
        {
            t0 = System.currentTimeMillis();
            rsa1.generateRSAKeyPair(b, f4, c);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("key generation time: " + t0/1000. + " sec.");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }

        // write
        try
        {
            rsa1.writeRSAPublicKey("pub"+(f4?"_f4":"")+(c?"_crt":"")+".txt");
            rsa1.secureWriteRSAPrivateKey("geheim", "pri"+(f4?"_f4":"")+(c?"_crt":"")+"_secure.txt");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }

        // read into second instance
        try
        {
            rsa2.readRSAPublicKey("pub"+(f4?"_f4":"")+(c?"_crt":"")+".txt");
            rsa2.secureReadRSAPrivateKey("geheim", "pri"+(f4?"_f4":"")+(c?"_crt":"")+"_secure.txt");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }

        // encrypt and decrypt
        System.out.println("---------- encryption / decyption ----------");
        try
        {
            byte[] plaintext = rsa1.util.randomBytes(16);
            System.out.println("plaintext      = " + Util.bytesToHex(plaintext));
            t0 = System.currentTimeMillis();
            byte[] ciphertext = rsa1.encryptKey(plaintext);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("encryption time: " + t0/1000. + " sec.");
            System.out.println("ciphertext     = " + Util.bytesToHex(ciphertext));
            t0 = System.currentTimeMillis();
            byte[] decryptedtext = rsa2.decryptKey(ciphertext);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("decryption time: " + t0/1000. + " sec.");
            System.out.println("decrypted text = " + Util.bytesToHex(decryptedtext));
            System.out.println(Util.bytesToHex(plaintext).equals(Util.bytesToHex(decryptedtext))?"SUCCEEDED":"FAILED");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }
        System.out.println();

        // sign and verify
        System.out.println("---------- signature ----------");
        try
        {
            byte[] message = rsa1.util.randomBytes(64);
            System.out.println("message      = " + Util.bytesToHex(message));
            t0 = System.currentTimeMillis();
            byte[] signature = rsa1.generateSignature(message);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("signature generation time: " + t0/1000. + " sec.");
            System.out.println("signature    = " + Util.bytesToHex(signature));
            t0 = System.currentTimeMillis();
            boolean verification = rsa2.verifySignature(message, signature);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("signature verification time: " + t0/1000. + " sec.");
            System.out.println("verification = " + (verification?"SUCCEEDED":"FAILED"));
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }
        System.out.println();

        // factor n from e and d
        if (!rsa1.crt)
        {
            System.out.println("---------- factoring from key pair ----------");
            try
            {
                t0 = System.currentTimeMillis();
                rsa1.factorFromKeyPair();
                t0 = System.currentTimeMillis() - t0;
                System.out.println("factoring time: " + t0/1000. + " sec.");
            }
            catch (Exception e)
            {
                System.out.println("ERROR: " + e.getMessage());
            }
            System.out.println();
        }
    }

    // test all four combinations for one bitlength
    private static void test(int b)
    {
        testOne(b, true, true);
        testOne(b, true, false);
        testOne(b, false, true);
        testOne(b, false, false);
    }

    // speedtest
    private static void speedtest(int b, int t)
    {
        System.out.println("b = " + b);
        RSA rsa = null;
        long t0;

        int tries = t;

        // key pair generation speed test
        try
        {
            t0 = System.currentTimeMillis();
            for (int i = 1; i <= tries; i++)
            {
                (new RSA()).generateRSAKeyPair(b, true, false);
            }
            t0 = System.currentTimeMillis() - t0;
            System.out.println("average key pair generation time (" + tries + " tries): " + t0/(tries*1000.) + " sec.");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }

        try
        {
            rsa = new RSA();
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }

        tries = t * 10;

        // encryption and decryption speed test
        try
        {
            byte[] plaintext = rsa.util.randomBytes(16);
            byte[] ciphertext;
            byte[] decryptedtext;

            rsa.generateRSAKeyPair(b, true, false);
            t0 = System.currentTimeMillis();
            for (int i = 1; i <= tries; i++)
                ciphertext = rsa.encryptKey(plaintext);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("average encryption (f4) time (" + tries + " tries): " + t0/(tries*1000.) + " sec.");

            rsa.generateRSAKeyPair(b, false, false);
            t0 = System.currentTimeMillis();
            for (int i = 1; i <= tries; i++)
                ciphertext = rsa.encryptKey(plaintext);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("average encryption (non-f4) time (" + tries + " tries): " + t0/(tries*1000.) + " sec.");

            rsa.generateRSAKeyPair(b, true, true);
            ciphertext = rsa.encryptKey(plaintext);
            t0 = System.currentTimeMillis();
            for (int i = 1; i <= tries; i++)
                decryptedtext = rsa.decryptKey(ciphertext);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("average decryption (crt) time (" + tries + " tries): " + t0/(tries*1000.) + " sec.");

            rsa.generateRSAKeyPair(b, true, false);
            ciphertext = rsa.encryptKey(plaintext);
            t0 = System.currentTimeMillis();
            for (int i = 1; i <= tries; i++)
                decryptedtext = rsa.decryptKey(ciphertext);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("average decryption (non-crt) time (" + tries + " tries): " + t0/(tries*1000.) + " sec.");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    // main, test different bitsizes
    public static void main(String[] args)
    {
        test(256);
        test(512);
        test(768);
        test(1023);
        test(1024);
        test(1025);
        speedtest(1024, 100);
        speedtest(2048, 100);
    }
}
