// SHA32 - looking for preimages and collisions
// Benne de Weger - TU/e - February 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 4 - application

import net.deweger.crypto.*;
import java.util.ArrayList;

public class SHA32
{
    private static byte[] shortHash(SHA256 sha256, byte[] data, int len) throws Exception
    {
        byte[] h = sha256.hash(data);
        byte[] h2 = new byte[len];
        System.arraycopy(h, 0, h2, 0, len);
        return h2;
    }

    public static void main(String[] args)
    {
        try
        {
            // parse arguments
            if (args.length != 1)
            {
                System.out.println("usage: java -cp .;crypto.jar SHA32 c");
                throw new Exception("wrong number of arguments");
            }
            int len = Integer.parseInt(args[0]);
            SHA256 sha256 = new SHA256();
            Util util = new Util();

            String h0 = Util.bytesToHex(util.randomBytes(len));
            byte[] h = new byte[len];
            byte[] msg = new byte[16];
            int count = 0;

            boolean found = false;
            System.out.println("\nlength "+ len + " preimage search:");
            while (!found)
            {
                msg = util.randomBytes(16);
                h = shortHash(sha256, msg, len);
                count++;
                found = h0.equals(Util.bytesToHex(h));
                if (count%1000000==0)
                    System.out.println("count: " + count/1000000 + " million");
            }
            System.out.println("target hash:     " + h0);
            System.out.println("preimage   :     " + Util.bytesToHex(msg));
            System.out.println("with SHA256:     " + Util.bytesToHex(sha256.hash(msg)));
            System.out.println("hash count :     " + count);

            byte[] m0 = util.randomBytes(16);
            h0 = Util.bytesToHex(shortHash(sha256, m0, len));
            count = 0;

            found = false;
            System.out.println("\nlength "+ len + " second preimage search:");
            while (!found)
            {
                msg = util.randomBytes(16);
                h = shortHash(sha256, msg, len);
                count++;
                found = h0.equals(Util.bytesToHex(h));
                if (count%1000000==0)
                    System.out.println("count: " + count/1000000 + " million");
            }
            System.out.println("target message:  " + Util.bytesToHex(m0));
            System.out.println("target hash:     " + Util.bytesToHex(sha256.hash(m0)));
            System.out.println("second preimage: " + Util.bytesToHex(msg));
            System.out.println("with SHA256:     " + Util.bytesToHex(sha256.hash(msg)));
            System.out.println("hash count :     " + count);

            count = 2;

            found = false;
            System.out.println("\nlength "+ len + " collision search:");
            byte[] start = util.randomBytes(32);
            byte[] tortoise = shortHash(sha256, start, len);
            byte[] hare = shortHash(sha256, tortoise, len);
            while (!Util.bytesToHex(tortoise).equals(Util.bytesToHex(hare)))
            {
                tortoise = shortHash(sha256, tortoise, len);
                hare = shortHash(sha256, shortHash(sha256, hare, len), len);
                count += 3;
                if (count%1000000<3)
                    System.out.println("count: " + count/1000000 + " million");
            }
            System.out.println("cycle found at count: " + count);
            tortoise = start;
            byte[] msg1 = tortoise;
            byte[] msg2 = hare;
            tortoise = shortHash(sha256, tortoise, len);
            hare = shortHash(sha256, hare, len);
            count += 2;
            while (!Util.bytesToHex(tortoise).equals(Util.bytesToHex(hare)))
            {
                msg1 = tortoise;
                msg2 = hare;
                tortoise = shortHash(sha256, tortoise, len);
                hare = shortHash(sha256, hare, len);
                count += 2;
                if (count%1000000<2)
                    System.out.println("count: " + count/1000000 + " million");
            }
            System.out.println("first message:   " + Util.bytesToHex(msg1));
            System.out.println("with SHA256:     " + Util.bytesToHex(sha256.hash(msg1)));
            System.out.println("second message:  " + Util.bytesToHex(msg2));
            System.out.println("with SHA256:     " + Util.bytesToHex(sha256.hash(msg2)));
            System.out.println("hash count :     " + count);

            count = 2;
            len = 2 * len;

            found = false;
            System.out.println("\nlength "+ len + " double length collision search:");
            start = util.randomBytes(32);
            tortoise = shortHash(sha256, start, len);
            hare = shortHash(sha256, tortoise, len);
            while (!Util.bytesToHex(tortoise).equals(Util.bytesToHex(hare)))
            {
                tortoise = shortHash(sha256, tortoise, len);
                hare = shortHash(sha256, shortHash(sha256, hare, len), len);
                count += 3;
                if (count%1000000<3)
                    System.out.println("count: " + count/1000000 + " million");
            }
            System.out.println("cycle found at count: " + count);
            tortoise = start;
            msg1 = tortoise;
            msg2 = hare;
            tortoise = shortHash(sha256, tortoise, len);
            hare = shortHash(sha256, hare, len);
            count += 2;
            while (!Util.bytesToHex(tortoise).equals(Util.bytesToHex(hare)))
            {
                msg1 = tortoise;
                msg2 = hare;
                tortoise = shortHash(sha256, tortoise, len);
                hare = shortHash(sha256, hare, len);
                count += 2;
                if (count%1000000<2)
                    System.out.println("count: " + count/1000000 + " million");
            }
            System.out.println("first message:   " + Util.bytesToHex(msg1));
            System.out.println("with SHA256:     " + Util.bytesToHex(sha256.hash(msg1)));
            System.out.println("second message:  " + Util.bytesToHex(msg2));
            System.out.println("with SHA256:     " + Util.bytesToHex(sha256.hash(msg2)));
            System.out.println("hash count :     " + count);
        }
        catch(Exception exc)
        {
            exc.printStackTrace();
        }
    }
}
