// Sophie Germain prime generation
// Benne de Weger - TU/e - February 2021

// FAECTOR Workshop Cryptographic Programming
// Assignment 5 - application and API:
//
// generate a Sophie Germain Prime
//     public static BigInteger generateSophieGermainPrime(int b)


import net.deweger.crypto.*;
import java.math.BigInteger;

public class SophieGermain
{
    // generate SG-prime of given number of bits
    public static BigInteger generateSophieGermainPrime(int b)
    {
        Util util = new Util();
        BigInteger p = BigInteger.ONE;
        BigInteger q = BigInteger.ONE;
        int count = 0;
        System.out.println("Generating Sophie Germain Prime... (may take a long time)");
        while (!p.isProbablePrime(100))
        {
            q = BigInteger.probablePrime(b-1, util.secureRandom);
            p = q.add(q).add(BigInteger.ONE);
            count++;
        }
        System.out.println("Sophie Germain Prime Generation (" + b + " bits) took " + count + " tries.");
        return p;
    }

    private static void test(int b)
    {
        try
        {
            long t0 = System.currentTimeMillis();
            BigInteger p = generateSophieGermainPrime(b);
            t0 = System.currentTimeMillis() - t0;
            System.out.println("hexadecimal:\n" + Util.bigIntegerToHex64(p) +
                               "\ndecimal:\n" + p.toString().replaceAll(".{80}", "$0-\n") +
                               "\ntime: " + t0/1000. + " sec.\n");
        }
        catch (Exception e)
        {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public static void main(String[] args)
    {
        test(10);
        test(20);
        test(30);
        test(40);
        test(50);
        test(256);
        test(512);
        test(1024);
        test(2048);
    }
}
